/*
  representation of nic proximity groupings.
  
  first a list of all nics in the fabric.
  then for each clos level, an array of group count then nic counts
  and indices into the nic array, each group of indices represents a
  set of nics at the same maximum distance from each other.

  for instance at some level:
  group_count, count, nic, nic, nic, count, nic, nic, nic, nic, nic
  2            3       1    2    3    5      4   5    6     7    8 

*/
typedef struct lf_proximity_t {
    lf_nic_t **nics;
    int num_nics;
    int num_levels;
    int *levels;
    int **groups;
} lf_proximity_t;

lf_proximity_t *lf_proximity_create(lf_fabric_t * fp);
void lf_proximity_free(lf_proximity_t * p);
